local TFCSystem_Utils = {}

function TFCSystem_Utils.noise(name, args)
    if isDebugEnabled() then
        print("TFC System - " .. name .. ": " .. args)
    end
end

function TFCSystem_Utils.formatCoords(x, y, z)
    local text = string.format("x=%s, y=%s, z=%s", x, y, z)
    return text
end

function TFCSystem_Utils.getIdByCoords(x, y, z)
    local id = x .. "-" .. y .. "-" .. z
    return id
end

function TFCSystem_Utils.getCoordsById(id)
    local coords = strsplit(id, "-")
    return tonumber(coords[1]), tonumber(coords[2]), tonumber(coords[3])
end

return TFCSystem_Utils